#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

	f_haveJoystick = input.initDInput(this->winId());
	if (!f_haveJoystick)
	{
		this->setWindowTitle(QString("%1 :: %2").arg(this->windowTitle()).arg("Joystick not found"));
	}
	else
	{
		this->setWindowTitle(QString("%1 :: %2").arg(this->windowTitle()).arg("Joystick present"));
	}

	// init tables
	tblAxis.initTbl(ui->tblAxis);
	tblAxis.setHHeaderText(0,"Axis ID");
	tblAxis.setHHeaderText(1,"Value");

	tblButtons.initTbl(ui->tblButtons);
	tblButtons.setHHeaderText(0,"Button ID");
	tblButtons.setHHeaderText(1,"State");

	// refresh timer interval (reads new values from joystick)
	if (f_haveJoystick)
	{
		tmr.setInterval(15);
		connect(&tmr,SIGNAL(timeout()),this,SLOT(readJoystickState()));
		tmr.start();
	}
}

void MainWindow::readJoystickState()
{
	if (!input.updateState()) return;

	ui->sliderVertical->setValue((-input.joyState.lY+1000)/20);
	ui->sliderHorizontal->setValue((input.joyState.lX+1000)/20);
	ui->dialRotation->setValue((input.joyState.lRz+1000)/20);

	ui->dialThrottle->setValue((input.joyState.rglSlider[0]+1000)/20);


	for (int r = 0; r < std::min(tblAxis.rows(),8); r++)
	{
		tblAxis.setText(r,0,QString("%1").arg(r));
		int value = (&input.joyState.lX)[r];
		tblAxis.setText( r,1, QString("%1").arg(value) );
	}

	for (int r = 0; r < tblButtons.rows(); r++)
	{
		tblButtons.setText( r,0,QString("%1").arg(r) );

		bool isPressed = input.joyState.rgbButtons[r] & 0x80;
		QString stateString("-");
		if (isPressed) stateString = QString("Pressed");

		tblButtons.setText( r,1, stateString );
	}
}

MainWindow::~MainWindow()
{
    delete ui;
}

