/*
 * xinputGamepad.cpp - part of xinputGamepad unit
 * copyright (c) 2011, fluxrobotics
 */

#include "xinputGamepad.h"

bool XInput::initJoystick()
{
	HRESULT hr = 0;

	hr = lpDI->EnumDevices(DI8DEVTYPE_JOYSTICK,XInput::EnumJoysticks,
					  this,DIEDFL_ATTACHEDONLY);
	if (!lpJoystick) return false;

	hr = lpJoystick->SetDataFormat(&c_dfDIJoystick);
	//if (FAILED(hr))	return false; //

	hr = lpJoystick->SetCooperativeLevel(hWnd,DISCL_FOREGROUND | DISCL_NONEXCLUSIVE);
	if (FAILED(hr))
		return false;

	hr = lpJoystick->EnumObjects(XInput::EnumObjects,this,DIDFT_ALL);
	if (FAILED(hr))
		return false;

	hr = lpJoystick->Acquire();

	return true;
}

void XInput::releaseJoystick()
{
	if (lpJoystick)
	{
		lpJoystick->Release();
		lpJoystick = 0;
	}
}

bool XInput::initDInput(HWND in_hWnd)
{
	hWnd = in_hWnd;
	HRESULT hr=0;
	hr=DirectInput8Create(GetModuleHandle(NULL),DIRECTINPUT_VERSION,
					   IID_IDirectInput8,(void**)&lpDI,NULL);
	if (FAILED(hr))
		return false;


	if (!initJoystick())
		return false;

	return true;
}

BOOL CALLBACK XInput::EnumJoysticks(const DIDEVICEINSTANCE* pdInst, VOID* pvRef)
{
	XInput *inp = reinterpret_cast<XInput*>(pvRef);
	inp->lpJoystick = NULL;

	HRESULT hr;

	hr = inp->lpDI->CreateDevice(pdInst->guidInstance,&inp->lpJoystick, NULL);
	if (FAILED(hr))
	{
		return DIENUM_CONTINUE;
	}
	return DIENUM_STOP;
}

BOOL CALLBACK XInput::EnumObjects(const DIDEVICEOBJECTINSTANCE* pdOI,
										 VOID* pvRef)
{
	XInput *inp = reinterpret_cast<XInput*>(pvRef);

	HRESULT hr;

	if(pdOI->dwType & DIDFT_AXIS )
	{
		DIPROPRANGE diprg;
		diprg.diph.dwSize = sizeof(DIPROPRANGE);
		diprg.diph.dwHeaderSize = sizeof(DIPROPHEADER);
		diprg.diph.dwHow = DIPH_BYID;
		diprg.diph.dwObj = pdOI->dwType; // Specify the enumerated axis
		diprg.lMin = -1000;
		diprg.lMax = +1000;

		// Set the range for the axis
		if(FAILED(inp->lpJoystick->SetProperty(DIPROP_RANGE, &diprg.diph)))
		{
			return DIENUM_STOP;
		}

		DIPROPDWORD dipdw1;
		dipdw1.diph.dwSize = sizeof(DIPROPDWORD);
		dipdw1.diph.dwHeaderSize = sizeof(DIPROPHEADER);
		dipdw1.diph.dwHow = DIPH_BYID;
		dipdw1.diph.dwObj = pdOI->dwType; // Specify the enumerated axis
		dipdw1.dwData = 2500;             // 25%

		hr = inp->lpJoystick->SetProperty(DIPROP_DEADZONE,&dipdw1.diph);
	}

	return DIENUM_CONTINUE;
}

bool XInput::updateState()
{
	if (!lpJoystick) return false;

	HRESULT hr = lpJoystick->GetDeviceState(sizeof(DIJOYSTATE),&joyState);
	if (FAILED(hr))
	{
		do
		{
			hr = lpJoystick->Acquire();
		}
		while(hr==DIERR_INPUTLOST || hr == DIERR_NOTACQUIRED);
	}
	return true;
}

bool XInput::releaseDInput()
{
	releaseJoystick();

	if (lpDI)
	{
		lpDI->Release();
		lpDI = 0;
	}
	return true;
}
