/*
 * xinputGamepad - extract of XInput class
 * some parts are made after example from Romix-Lab aritcle:
 *    http://romix-lab.ru/blog/programming/7.html
 * copyright (c) 2011, fluxrobotics
 */
#ifndef H_XINPUT_GAMEPAD_H
#define H_XINPUT_GAMEPAD_H

#define DIRECTINPUT_VERSION 0x0800
#include "dinput.h"

class XInput
{
public:
	bool initDInput(HWND in_hWnd);
	bool updateState();
	bool releaseDInput();

	LPDIRECTINPUT8 lpDI;
	LPDIRECTINPUTDEVICE8 lpJoystick;
	DIJOYSTATE joyState;

	bool joyNewKey[32];
	static BOOL CALLBACK EnumJoysticks(const DIDEVICEINSTANCE* pdInst, VOID* pvRef);
	static BOOL CALLBACK EnumObjects(const DIDEVICEOBJECTINSTANCE* pdOI, VOID* pvRef);

	bool initJoystick();
	void releaseJoystick();

	HWND hWnd;

	XInput() : lpDI(0),lpJoystick(0), hWnd(0) { };
};

#endif
