// testers:
// Ains Tedetre
//
//

#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <windows.h>
#pragma comment(lib, "Advapi32.lib")


#include <QFile>

#include <QFileDialog>

#include <QRegExp>
#include <QNetworkInterface>


MainWindow::MainWindow(QString start_Path, QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
	ui->setupUi(this);

	// Get current exe file name and exe directory
	startPath = QDir().absoluteFilePath(start_Path);
	startDir = QFileInfo(startPath).path() + QString("\\");

	strConfigPath = QString(startDir+QString(szConfigFile));

	// Determine system version
	detectWinVer();
	isVista = winKrnlMajVer >= 6; // !!!
	ui->cbVistaPlus->setChecked(isVista); // vista or later


	f_forcebindip = isForceBindIPInstalled();
	ui->cbForceBindIP->setChecked(f_forcebindip);


	loadRegInfo();
	if (loadConfig())
	{
		ui->leSCPath->setText(strSCFilePreferred);
	}
	else
	{
		ui->leSCPath->setText(strSCInstallFile);
	}



	ui->cbFirewallException->setEnabled(isVista);
	ui->cbCompabilityParams->setEnabled(isVista);
	ui->cbPaletteTricks->setEnabled(isVista);
	ui->cbAdministrator->setEnabled(isVista);

	if (isVista)
	{
		ui->cbFirewallException->setChecked(f_cfgFirewall);
		ui->cbCompabilityParams->setChecked(f_cfgCompability);
		ui->cbPaletteTricks->setChecked(f_cfgPalette);
		ui->cbAdministrator->setChecked(f_cfgAdministrator);
	}


	enumNetworks();
	if (!vNetworks.size())
	{
		ui->rbHamachi->setEnabled(false);
		ui->rbSelNetwork->setEnabled(false);
		ui->btnLaunch->setEnabled(false);
	}
	else
	{
		for (size_t i=0; i < vNetworks.size(); i++)
		{
			ui->cbNetworks->addItem(vNetworks[i].shortname);
		}

		strHamachiIP = getHamachiNetworkIP();
		if (strHamachiIP.length())
		{
			ui->leHamachiIP->setText(strHamachiIP);
			ui->rbHamachi->setChecked(true);
			ui->rbSelNetwork->setChecked(false);
		}
		else
		{
			ui->leHamachiIP->setText("");
			ui->rbHamachi->setChecked(false);
			ui->rbHamachi->setEnabled(false);
			ui->rbSelNetwork->setChecked(true);
		}
	}




	QApplication::connect(ui->btnCancel,SIGNAL(pressed()),this,SLOT(onClose()));
	QApplication::connect(ui->btnLaunch,SIGNAL(pressed()),this,SLOT(onLaunch()));
	QApplication::connect(ui->btnBrowse,SIGNAL(pressed()),this,SLOT(onBrowse()));
	QApplication::connect(ui->btnAbout,SIGNAL(pressed()),this,SLOT(onAbout()));
}

bool MainWindow::isValidSCFile(const QString &path)
{
	if (path.length() > 1 && QFile::exists(path))
	{
		// verify SC version here?
		return true;
	}
	else
	{
		return false;
	}
}

void MainWindow::onClose()
{
	QString path = ui->leSCPath->text();

	if (isValidSCFile(path))
	{
		strSCFilePreferred = ui->leSCPath->text();
		saveConfig();
	}

	this->close();
}

void MainWindow::onLaunch()
{
	// load UI cfgFlags
	if (ui->cbFirewallException->isEnabled())
		f_cfgFirewall = ui->cbFirewallException->isChecked();

	if (ui->cbCompabilityParams->isEnabled())
		f_cfgCompability = ui->cbCompabilityParams->isChecked();

	if (ui->cbPaletteTricks->isEnabled())
		f_cfgPalette = ui->cbPaletteTricks->isChecked();

	if (ui->cbAdministrator->isEnabled())
		f_cfgAdministrator = ui->cbAdministrator->isChecked();


	if (!f_forcebindip)
	{
		if (!installForcebindIP())
		{
			ui->statusBar->showMessage(tr("Unable to install forceBindIP."\
										  " Make sure for running app with Administrative privileges."));
			return;
		}
	}


	// load path from UI
	runPath = ui->leSCPath->text();
	QString ip;
	if (ui->rbHamachi->isChecked())
	{
		ip = strHamachiIP;
	}
	else
	{
		int idx = ui->cbNetworks->currentIndex();
		if (idx == -1)
		{
			// No network selected
			return;
		}

		ip = vNetworks[idx].ip;
	}

	if (isValidSCFile(runPath))
	{
		strSCFilePreferred = runPath;
		saveConfig();
	}
	else
		return; // fail



	this->showMinimized();
	if (isVista)
	{
		if (f_cfgFirewall)
		{
			doFirewallTricks();
		}

		// Run dialog, make it foreground, add firewall exception
		if (f_cfgCompability)
		{
			setupAppCompability();
			if (f_cfgPalette)
			{
				doVistaDesktopTricks();
			}
		}

	}


	const QString program("forcebindip");
	QString arg2 = runPath;//QString("\"") + runPath + QString("\"");
	QStringList args = QStringList(ip) << arg2;

	QProcess::execute(program, args);
	// close dialog
	close();
}

bool MainWindow::setupAppCompability()
{
	// Manual what to automate:
	// http://www.jmedved.com/2009/02/starcraft-color-problem/

	// Manual how to automate:
	// http://www.sevenforums.com/tutorials/316-compatibility-mode.html

	// Extract:
	// HKEY_CURRENT_USER\Software\Microsoft\Windows NT\CurrentVersion\AppCompatFlags\Layers
	//    REG_SZ, Name = Ap full path to exe, Value = by formula -> compability mode

	// Formula: [Compatibility Mode (only one)] + space +
	//             + [Settings (one or more with a space inbetween)] +
	//             + space + [Privilege Level]
	// Possible combination: WINXPSP3 256Color 640x480 DISABLEDWM HIGHDPIAWARE RUNASADMIN
	// Final value to write: DISABLEDWM HIGHDPIAWARE RUNASADMIN

	HKEY keyCreated;
	DWORD disposition;
	int result = RegCreateKeyExA(HKEY_CURRENT_USER,
				  "Software\\Microsoft\\Windows NT\\CurrentVersion\\AppCompatFlags\\Layers",
				  0,
				  0,
				  REG_OPTION_NON_VOLATILE,
				  KEY_CREATE_SUB_KEY|KEY_QUERY_VALUE|KEY_SET_VALUE,
				  0,
				  &keyCreated,
				  &disposition);

	if (result != ERROR_SUCCESS)
		return false;



	const char szValueData[] = "DISABLEDWM HIGHDPIAWARE RUNASADMIN";

	QByteArray baRunPath = runPath.toAscii();
	result = RegSetValueExA(keyCreated,baRunPath.constData(),
							0,
							REG_SZ,
							(const BYTE*)szValueData,
							sizeof(szValueData));
	if (result != ERROR_SUCCESS)
		return false;

	return true;
}

bool MainWindow::doVistaDesktopTricks()
{
	// Display properties dialog call
	// set it foreground

	// command: rundll32.exe shell32.dll,Control_RunDLL desk.cpl
	procDesktopCPL.start(QString("rundll32.exe"),
			   QStringList("shell32.dll,Control_RunDLL") << QString("desk.cpl"));
	Sleep(500); // wait window to appear

	HWND hWndCpl = FindWindowA(0,"Display Properties");
	if (!hWndCpl)
	{
		hWndCpl = FindWindowA(0,"Display Settings");
		if (!hWndCpl)
			return false;
	}
	SetForegroundWindow(hWndCpl);
	SetActiveWindow(hWndCpl);


	return true; // non-implemented
}

bool MainWindow::doFirewallTricks()
{
	/*/ To add app exception in WIN XP (maybe so in Vista&Seven+ too)
	administarator run cmd prompt>
	 "netsh firewall add allowedprogram program = C:\prog.exe " \
	 "name = StarCraft993 mode = ENABLE scope = ALL profile = ALL"
	/*/

	QString cmdNetsh = QString("netsh firewall add allowedprogram "\
							   "program = \"%1\" name = StarCraft993 "\
							   "mode = ENABLE scope = ALL profile = ALL").arg(runPath);

	QProcess::execute(cmdNetsh);

	/*/ Add port exception?
	administarator run cmd prompt>
	  "add portopening protocol = ALL " \
	  "port = 6112 name = StarCraftTCPUDP scope = ALL"
	/*/
	QProcess::execute("netsh firewall add portopening protocol = ALL "\
					  "port = 6112 name = StarCraftTCPUDP scope = ALL");

	return false; // non implemented
}

bool MainWindow::detectWinVer()
{
	OSVERSIONINFOEX osvi;
	BOOL bOsVersionInfoEx;

	ZeroMemory(&osvi, sizeof(osvi));

	osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);

	if( !(bOsVersionInfoEx = GetVersionEx((OSVERSIONINFO *) &osvi)) )
	{
		osvi.dwOSVersionInfoSize = sizeof (OSVERSIONINFO);
		if (! GetVersionEx ( (OSVERSIONINFO *) &osvi) )
			return false;
	}

	switch (osvi.dwPlatformId)
	{
	case VER_PLATFORM_WIN32_NT:
		if (osvi.dwMajorVersion >= 7)
			winKrnlMajVer = 7;
		else
			winKrnlMajVer = osvi.dwMajorVersion;
		break;

	default:
		winKrnlMajVer = 5;
	}
	return true;
}

void MainWindow::onBrowse()
{
	QString fileName =
			QFileDialog::getOpenFileName(this,
										 tr("Browse for Starcraft.exe"),
										 QString(),
										 tr("Executable (*.exe)"));
	if (!fileName.isEmpty())
	{
		if (isValidSCFile(fileName))
		{
			strSCFilePreferred = fileName;
			ui->leSCPath->setText(strSCFilePreferred);
		}
	}
}

void MainWindow::onAbout()
{

}

QString MainWindow::getHamachiNetworkIP()
{
	const QString strHamachiNetworkName("Hamachi");
	for (size_t i=0; i < vNetworks.size(); i++)
	{
		if (vNetworks[i].name == strHamachiNetworkName)
			return vNetworks[i].ip;
	}
	return QString(); // empty string
}

MainWindow::~MainWindow()
{
    delete ui;
}

bool MainWindow::loadRegInfo()
{
	f_SCInstalled = false;
	char szSCPath[1024] = {0};

	HKEY result;
	if (RegOpenKeyA(HKEY_LOCAL_MACHINE,"SOFTWARE\\Blizzard Entertainment\\Starcraft",
				   &result) == ERROR_SUCCESS)
	{
		DWORD type = REG_SZ;
		DWORD length = sizeof(szSCPath);
		if (RegQueryValueExA(result,"InstallPath",NULL,&type,
							 (LPBYTE)szSCPath,&length) == ERROR_SUCCESS)
		{
			f_SCInstalled = true;
			strSCInstallDir = QString(szSCPath) + QString("\\");
			strSCInstallFile = strSCInstallDir + "starcraft.exe";
		}
	}
	return true;
}

const char MainWindow::szConfigFile[] = "config.txt";

bool MainWindow::isForceBindIPInstalled()
{
	QString strSysDir = getSysDir();

	bool exe1 = QFile::exists(strSysDir+QString("ForceBindIP.exe"));
	bool dll1 = QFile::exists(strSysDir+QString("BindIP.dll"));
	if (exe1 && dll1)
		return true;
	return false;
}

QString MainWindow::getSysDir()
{
	CHAR szSysDir[1024]={0};
	if (!GetSystemDirectoryA(szSysDir,sizeof(szSysDir))) return false;
	return QString(szSysDir)+QString("\\");
}

bool MainWindow::installForcebindIP()
{
	QString strSysDir = getSysDir(); // this is where to install

	// search in current dir and not in sys dir
	bool exe1 = QFile::exists(startDir+QString("ForceBindIP.exe"));
	bool dll1 = QFile::exists(startDir+QString("BindIP.dll"));
	bool package_exists = exe1 && dll1;

	if (!package_exists)
	{
		// download package from
		// http://www.r1ch.net/stuff/forcebindip/download/ForceBindIP-1.2a.zip


		// set finished flag when ready
		package_exists = true;
	}

	if (package_exists)
	{
		bool resExe1 = QFile::copy(startDir+QString("ForceBindIP.exe"),
								   strSysDir+"ForceBindIP.exe");
		bool resDll1 = QFile::copy(startDir+QString("BindIP.dll"),
								   strSysDir+"BindIP.dll");
		return resExe1 || resDll1; // one of the files may already exists
	}

	return false;
}

bool MainWindow::loadConfig()
{
	f_cfgFirewall = true;
	f_cfgCompability = true;
	f_cfgPalette = true;
	f_cfgAdministrator = true;

	if (!QFile::exists(szConfigFile))
		return false;

	QByteArray baConfigPath = strConfigPath.toAscii();
	FILE *f = fopen(baConfigPath.constData(),"rt");
	if (!f) return false;

	// Format: <spaces>NAME<spaces>=<spaces>VAL<spaces><EOL>
	QRegExp rx("\\s*(\\w+)\\s*=\\s*([A-Za-z0-9][A-Za-z0-9\\s_/\\.:\\\\]*)\\s*\\n");
	try
	{
		char szBuf[1024] = {0};

		while(!feof(f))
		{
			if (!fgets(szBuf,sizeof(szBuf),f))
				break;
			QString line(szBuf);
			int pos = rx.indexIn(line);
			if (pos == -1)
				continue; // wrong string

			QStringList sl = rx.capturedTexts();

			if (sl.count() != 3)
				continue;

			if (sl[1] == "PATH")
			{
				if (isValidSCFile(sl[2]))
					strSCFilePreferred = sl[2];
				continue;
			}

			if (sl[1] == "FIREWALL_EXCEPTION")
			{
				f_cfgFirewall = sl[2].toInt();
				continue;
			}

			if (sl[1] == "COMPABILITY")
			{
				f_cfgCompability = sl[2].toInt();
				continue;
			}

			if (sl[1] == "PALETTE")
			{
				f_cfgPalette = sl[2].toInt();
				continue;
			}

			if (sl[1] == "ADMINISTRATOR")
			{
				f_cfgAdministrator = sl[2].toInt();
				continue;
			}
		}
	}
	catch(int err)
	{
		fclose(f);
		return false;
	}
	fclose(f);
	return true;
}

bool MainWindow::saveConfig()
{
	QString strOutConfig = strSCFilePreferred;

	QByteArray baConfigPath = strConfigPath.toAscii();
	FILE *f = fopen(baConfigPath.constData(),"wt");
	if (!f) return false;

	try
	{
		if (!fprintf(f,"PATH=%s\n",(char*)strOutConfig.toAscii().data())) throw 1;
		if (!fprintf(f,"FIREWALL_EXCEPTION=%d\n",(int)f_cfgFirewall)) throw 2;
		if (!fprintf(f,"COMPABILITY=%d\n",(int)f_cfgCompability)) throw 3;
		if (!fprintf(f,"PALETTE=%d\n",(int)f_cfgPalette)) throw 4;
		if (!fprintf(f,"ADMINISTRATOR=%d\n",(int)f_cfgAdministrator)) throw 5;
	}
	catch(int err)
	{
		fclose(f);
		return false;
	}

	fclose(f);
	return true;
}

bool MainWindow::enumNetworks()
{
	QList<QNetworkInterface> vNI = QNetworkInterface::allInterfaces();
	for (QList<QNetworkInterface>::iterator ni = vNI.begin();
		 ni != vNI.end(); ++ni)
	{
		QString name = ni->humanReadableName();
		QString ip;
		QList<QNetworkAddressEntry> addresses = ni->addressEntries();
		if (addresses.size())
		{
			ip = addresses.begin()->ip().toString();
		}

		vNetworks.push_back(XNetwork(name,ip));
	}
	return true;
}
