#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>

#include <vector>

#include <QProcess>

using namespace std;

namespace Ui {
    class MainWindow;
}

struct XNetwork
{
	QString name;
	QString ip;
	bool f_valid;

	QString shortname;

	XNetwork() { f_valid = false; };
	XNetwork(const QString &name_,const QString &ip_)
	{
		name = name_;
		ip = ip_;
		if (ip.length())
		{
			f_valid = true;
			shortname = name + " | " + ip;
		}
		else
		{
			f_valid = false;
			shortname = name + " | NOT connected";
		}
	};
};

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
	explicit MainWindow(QString start_Path = QString(), QWidget *parent = 0);
    ~MainWindow();

private:
    Ui::MainWindow *ui;

	QString startPath;
	QString startDir;

	bool f_forcebindip;

	bool f_SCInstalled;
	QString strSCInstallDir;
	QString strSCInstallFile;
	QString strHamachiIP;

	QProcess procDesktopCPL;

	QString strConfigPath;
	QString strSCFilePreferred; // from config
	int f_cfgFirewall;
	int f_cfgCompability;
	int f_cfgPalette;
	int f_cfgAdministrator;

	QString runPath; // determined on Launch


	bool isVista;
	int winKrnlMajVer; // 4,5,6,7,8 - (NT,XP,VISTA,SEVEN,8 resp.)


	bool isForceBindIPInstalled();
	std::vector<XNetwork> vNetworks;

	bool enumNetworks();

	bool loadRegInfo();
	bool loadConfig();
	bool saveConfig();
	static const char szConfigFile[];

	QString getHamachiNetworkIP();

	bool isValidSCFile(const QString &path);

	bool detectWinVer();
	bool doVistaDesktopTricks();
	bool doFirewallTricks();

	bool setupAppCompability();

	bool installForcebindIP();

	QString getSysDir();

private slots:
	void onClose();
	void onLaunch();
	void onBrowse();
	void onAbout();
};

#endif // MAINWINDOW_H
