#include "mainwindow.h"
#include "ui_mainwindow.h"

#include "dlgAbout.h"

#include <vector>
#include <QVBoxLayout>

using namespace std;




MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    this->showMaximized();

	// Member func change: Error value
	connect(this->ui->sbErrKNeg_L,SIGNAL(valueChanged(double)),
			this,SLOT(onSbErrNegLChanged(double)));
	connect(this->ui->sbErrKNeg_R,SIGNAL(valueChanged(double)),
			this,SLOT(onSbErrNegRChanged(double)));

	connect(this->ui->sbErrKZero_L,SIGNAL(valueChanged(double)),
			this,SLOT(onSbErrZeroLChanged(double)));
	connect(this->ui->sbErrKZero_R,SIGNAL(valueChanged(double)),
			this,SLOT(onSbErrZeroRChanged(double)));

	connect(this->ui->sbErrKPos_L,SIGNAL(valueChanged(double)),
			this,SLOT(onSbErrPosLChanged(double)));
	connect(this->ui->sbErrKPos_R,SIGNAL(valueChanged(double)),
			this,SLOT(onSbErrPosRChanged(double)));

	// Member func change: Diff Error value
	connect(this->ui->sbDErrKNeg_L,SIGNAL(valueChanged(double)),
			this,SLOT(onSbDErrNegLChanged(double)));
	connect(this->ui->sbDErrKNeg_R,SIGNAL(valueChanged(double)),
			this,SLOT(onSbDErrNegRChanged(double)));

	connect(this->ui->sbDErrKZero_L,SIGNAL(valueChanged(double)),
			this,SLOT(onSbDErrZeroLChanged(double)));
	connect(this->ui->sbDErrKZero_R,SIGNAL(valueChanged(double)),
			this,SLOT(onSbDErrZeroRChanged(double)));

	connect(this->ui->sbDErrKPos_L,SIGNAL(valueChanged(double)),
			this,SLOT(onSbDErrPosLChanged(double)));
	connect(this->ui->sbDErrKPos_R,SIGNAL(valueChanged(double)),
			this,SLOT(onSbDErrPosRChanged(double)));

	// signals on click modelling buttons
	connect(this->ui->btnRunStep,SIGNAL(pressed()),
			this,SLOT(onStartModellingStep()));
	connect(this->ui->btnRunChirp,SIGNAL(pressed()),
			this,SLOT(onStartModellingChirp()));


	connect(this->ui->actionSave,SIGNAL(triggered()),this,SLOT(onSave()));
	connect(this->ui->actionLoad,SIGNAL(triggered()),this,SLOT(onLoad()));
	connect(this->ui->actionExit,SIGNAL(triggered()),this,SLOT(close()));

	connect(this->ui->actionAbout,SIGNAL(triggered()),this,SLOT(onAbout()));
	connect(this->ui->actionHelp,SIGNAL(triggered()),this,SLOT(onHelpContext()));

	connect(this->ui->actionStartStep,SIGNAL(triggered()),this,SLOT(onStartModellingStep()));
	connect(this->ui->actionStartChirp,SIGNAL(triggered()),this,SLOT(onStartModellingChirp()));


	// Init member fuzzy variables
	fuzzyErr.neg.type = XFUNC_POSNEG;    //   --\___
	fuzzyErr.nz.type = XFUNC_NEGPOSNEG;  //   __/\__
	fuzzyErr.pos.type = XFUNC_NEGPOS;    //   __/---

	fuzzyDErr.neg.type = XFUNC_POSNEG;    //   --\___
	fuzzyDErr.nz.type = XFUNC_NEGPOSNEG;  //   __/\__
	fuzzyDErr.pos.type = XFUNC_NEGPOS;    //   __/---

	// draw first position of member func
	UpdateMemberFuncValues();
	InitMemberFuncGraph();
	UpdateMemberFuncGraph();

	InitOutputGraph();
}


void MainWindow::onAbout()
{
	DlgAbout dlgAbout(this);
	dlgAbout.exec();
}

void MainWindow::onHelpContext()
{
	Beep(200,100);
}

void MainWindow::onSave()
{
	Beep(500,100);
}

void MainWindow::onLoad()
{
	Beep(1000,100);
}

// Sb Error
void MainWindow::onSbErrNegLChanged(double newVal)
{
	double maxValue = ui->sbErrKNeg_R->value();
	if (newVal > maxValue) ui->sbErrKNeg_L->setValue(maxValue);
	memberFuncChanged();
}
void MainWindow::onSbErrNegRChanged(double newVal)
{
	double minValue = ui->sbErrKNeg_L->value();
	if (newVal < minValue) ui->sbErrKNeg_R->setValue(minValue);
	memberFuncChanged();
}
void MainWindow::onSbErrZeroLChanged(double newVal)
{
	double maxValue = ui->sbErrKZero_R->value();
	if (newVal > maxValue) ui->sbErrKZero_L->setValue(maxValue);
	memberFuncChanged();
}
void MainWindow::onSbErrZeroRChanged(double newVal)
{
	double minValue = ui->sbErrKZero_L->value();
	if (newVal < minValue) ui->sbErrKZero_R->setValue(minValue);
	memberFuncChanged();
}
void MainWindow::onSbErrPosLChanged(double newVal)
{
	double maxValue = ui->sbErrKPos_R->value();
	if (newVal > maxValue) ui->sbErrKPos_L->setValue(maxValue);
	memberFuncChanged();
}
void MainWindow::onSbErrPosRChanged(double newVal)
{
	double minValue = ui->sbErrKPos_L->value();
	if (newVal < minValue) ui->sbErrKPos_R->setValue(minValue);
	memberFuncChanged();
}

// Sb DError
void MainWindow::onSbDErrNegLChanged(double newVal)
{
	memberFuncChanged();
}
void MainWindow::onSbDErrNegRChanged(double newVal)
{
	memberFuncChanged();
}
void MainWindow::onSbDErrZeroLChanged(double newVal)
{
	memberFuncChanged();
}
void MainWindow::onSbDErrZeroRChanged(double newVal)
{
	memberFuncChanged();
}
void MainWindow::onSbDErrPosLChanged(double newVal)
{
	memberFuncChanged();
}
void MainWindow::onSbDErrPosRChanged(double newVal)
{
	memberFuncChanged();
}

void MainWindow::UpdateMemberFuncValues()
{
	// Error function
	// Negative
	fuzzyErr.neg.left = ui->sbErrKNeg_L->value();
	fuzzyErr.neg.right = ui->sbErrKNeg_R->value();

	// Near Zero
	fuzzyErr.nz.left = ui->sbErrKZero_L->value();
	fuzzyErr.nz.right = ui->sbErrKZero_R->value();

	// Positive
	fuzzyErr.pos.left = ui->sbErrKPos_L->value();
	fuzzyErr.pos.right = ui->sbErrKPos_R->value();

	// Diff Error function
	// Negative
	fuzzyDErr.neg.left = ui->sbDErrKNeg_L->value();
	fuzzyDErr.neg.right = ui->sbDErrKNeg_R->value();

	// Near Zero
	fuzzyDErr.nz.left = ui->sbDErrKZero_L->value();
	fuzzyDErr.nz.right = ui->sbDErrKZero_R->value();

	// Positive
	fuzzyDErr.pos.left = ui->sbDErrKPos_L->value();
	fuzzyDErr.pos.right = ui->sbDErrKPos_R->value();
}

bool MainWindow::InitMemberFuncGraph()
{
	vector<double> vx;
	vector<double> vy;

	// === Error ===
	vgdFuncErr.resize(3);
	vgdFuncErr[0] = GraphData(vx,vy,-1,"Large Negative",Qt::red,false,3);
	vgdFuncErr[1] = GraphData(vx,vy,-1,"Near Zero",Qt::green,false,3);
	vgdFuncErr[2] = GraphData(vx,vy,-1,"Large Positive",Qt::blue,false,3);
	ui->plotFuncErr->init(-3.0f,3.0f,0,1.1f,false,tr("e"),tr("f"));
	ui->plotFuncErr->drawGraph(vgdFuncErr);

	// === Diff Error ===
	vgdFuncDiffErr.resize(3);
	vgdFuncDiffErr[0] = GraphData(vx,vy,-1,"Large Negative",Qt::red,false,3);
	vgdFuncDiffErr[1] = GraphData(vx,vy,-1,"Near Zero",Qt::green,false,3);
	vgdFuncDiffErr[2] = GraphData(vx,vy,-1,"Large Positive",Qt::blue,false,3);
	ui->plotFuncDiffErr->init(-3.0f,3.0f,0,1.1f,false,tr("de"),tr("f"));
	ui->plotFuncDiffErr->drawGraph(vgdFuncDiffErr);

	return true;
}

bool MainWindow::InitOutputGraph()
{
	vector<double> vx;
	vector<double> vy;

	vgdResults.resize(3);
	vgdResults[0] = GraphData(vx,vy,-1,tr("Closed loop"),Qt::blue,false,3);
	vgdResults[1] = GraphData(vx,vy,-1,tr("PID loop"),Qt::darkGreen,false,3);
	vgdResults[2] = GraphData(vx,vy,-1,tr("Fuzzy Control"),Qt::red,false,3);


	double model_time_max = ui->sbModelTime->value();
	// maximum 300% initial overshoot constant
	double max_Y_value = ui->sbSetPoint->value()*3;
	ui->plotResults->init(0,model_time_max,0,max_Y_value,true,"t","f");
	ui->plotResults->drawGraph(vgdResults);
	return true;
}

void MainWindow::UpdateMemberFuncGraph()
{
	vector<double> vx;
	vector<double> vy;

	// Negative graph
	vx.clear();
	vy.clear();

	vx.push_back(-10);
	vx.push_back(fuzzyErr.neg.left);
	vx.push_back(fuzzyErr.neg.right);
	vx.push_back(10);

	vy.push_back(1.0);
	vy.push_back(1.0);
	vy.push_back(0.0);
	vy.push_back(0.0);

	vgdFuncErr[0] = GraphData(vx,vy,-1,"Large Negative",Qt::red,false,2);

	//vgdFuncErr[0]

	// Near Zero graph
	vx.clear();
	vy.clear();

	vx.push_back(-10);
	vx.push_back(fuzzyErr.nz.left);
	vx.push_back(0);
	vx.push_back(fuzzyErr.nz.right);
	vx.push_back(10);

	vy.push_back(0.0);
	vy.push_back(0.0);
	vy.push_back(1.0);
	vy.push_back(0.0);
	vy.push_back(0.0);

	vgdFuncErr[1] = GraphData(vx,vy,-1,"Near Zero",Qt::green,false,2);

	// Positive graph
	vx.clear();
	vy.clear();

	vx.push_back(-10);
	vx.push_back(fuzzyErr.pos.left);
	vx.push_back(fuzzyErr.pos.right);
	vx.push_back(10);

	vy.push_back(0.0);
	vy.push_back(0.0);
	vy.push_back(1.0);
	vy.push_back(1.0);

	vgdFuncErr[2] = GraphData(vx,vy,-1,"Large Positive",Qt::blue,false,2);

	ui->plotFuncErr->updateGraph(vgdFuncErr);





	// === Diff Error ===
	vgdFuncDiffErr.resize(3);

	// Negative graph
	vx.clear();
	vy.clear();

	vx.push_back(-10);
	vx.push_back(fuzzyDErr.neg.left);
	vx.push_back(fuzzyDErr.neg.right);
	vx.push_back(10);

	vy.push_back(1.0);
	vy.push_back(1.0);
	vy.push_back(0.0);
	vy.push_back(0.0);

	vgdFuncDiffErr[0] = GraphData(vx,vy,-1,"Large Negative",Qt::red,false,2);

	// Near Zero graph
	vx.clear();
	vy.clear();

	vx.push_back(-10);
	vx.push_back(fuzzyDErr.nz.left);
	vx.push_back(0);
	vx.push_back(fuzzyDErr.nz.right);
	vx.push_back(10);

	vy.push_back(0.0);
	vy.push_back(0.0);
	vy.push_back(1.0);
	vy.push_back(0.0);
	vy.push_back(0.0);

	vgdFuncDiffErr[1] = GraphData(vx,vy,-1,"Near Zero",Qt::green,false,2);

	// Positive graph
	vx.clear();
	vy.clear();

	vx.push_back(-10);
	vx.push_back(fuzzyDErr.pos.left);
	vx.push_back(fuzzyDErr.pos.right);
	vx.push_back(10);

	vy.push_back(0.0);
	vy.push_back(0.0);
	vy.push_back(1.0);
	vy.push_back(1.0);

	vgdFuncDiffErr[2] = GraphData(vx,vy,-1,"Large Positive",Qt::blue,false,2);

	ui->plotFuncDiffErr->updateGraph(vgdFuncDiffErr);
}



MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::memberFuncChanged()
{
	UpdateMemberFuncValues();
	UpdateMemberFuncGraph();
}

void MainWindow::onStartModellingStep()
{
	double setpoint = ui->sbSetPoint->value();
	double model_time_max = ui->sbModelTime->value();
	int num_step_iterations = (int)(model_time_max / deltaT_sec);

	double Kp = ui->sbKp->value();
	double Ki = ui->sbKi->value();
	double Kd = ui->sbKd->value();

	// Open LOOP Transient graph
	double max_Y_value = 0;
	if (1)
	{
		vector<double> vx;
		vector<double> vy;
		vx.clear();
		vy.clear();

		double time = deltaT_sec;

		double output = 0;
		double err = 0;
		double prevErr1 = 0;
		double derr = 0;

		XTRANSFERFCN fcn;

		for (int i = 0; i < num_step_iterations; i++)
		{
			prevErr1 = err;
			err = setpoint - output;
			derr = (err-prevErr1)/deltaT_sec;

			fcn.update(err);
			output = fcn.getOutput();

			max_Y_value = max(max_Y_value,output);

			time+=deltaT_sec;

			vx.push_back(time);
			vy.push_back(output);
		};

		vgdResults[0] = GraphData(vx,vy,-1,tr("Closed loop"),Qt::blue,false,3);
	}


	// PID Control loop
	if (1)
	{
		vector<double> vx;
		vector<double> vy;
		vx.clear();
		vy.clear();

		double time = deltaT_sec;

		double output = 0;
		double err = 0;
		double p1err = 0;
		double p2err = 0;

		XTRANSFERFCN fcn;
		XPID pid(Kp,Ki,Kd);

		for (int i = 0; i < num_step_iterations; i++)
		{
			p2err = p1err;
			p1err = err;
			err = setpoint - output;

			pid.update(err,p1err,p2err,deltaT_sec);
			double pid_ctrl_value = pid.getOutput();

			fcn.update(pid_ctrl_value);
			output = fcn.getOutput();

			max_Y_value = max(max_Y_value,output);

			time+=deltaT_sec;

			vx.push_back(time);
			vy.push_back(output);
		};

		vgdResults[1] = GraphData(vx,vy,-1,tr("PID loop"),Qt::darkGreen,false,3);
	}

	// Fuzzy logic controller Control loop
	if (1)
	{
		vector<double> vx;
		vector<double> vy;
		vx.clear();
		vy.clear();

		double time = deltaT_sec;

		double output = 0;
		double err = 0;
		double p1err = 0;
		double p2err = 0;
		double derr = 0;

		XTRANSFERFCN fcn;

		double fuzzyAmpValue = ui->sbOutputAmp->value();

		for (int i = 0; i < num_step_iterations; i++)
		{
			p2err = p1err;
			p1err = err;
			err = setpoint - output;
			derr = (err - p1err)/deltaT_sec;

			int fuzzifiedErr = fuzzyErr.retFuncIDByX(err);
			int fuzzifiedDErr = fuzzyDErr.retFuncIDByX(derr);

			double defuzzified_ret_val = 0;

			// Fuzzy rules based logic solution:

			// P1:
			if (fuzzifiedErr == XFUZZYVAR_POS && fuzzifiedDErr == XFUZZYVAR_NZ)
				defuzzified_ret_val = +1;

			// P2:
			if (fuzzifiedErr == XFUZZYVAR_NEG && fuzzifiedDErr == XFUZZYVAR_NZ)
				defuzzified_ret_val = -1;

			// P3:
			if (fuzzifiedErr == XFUZZYVAR_NZ && fuzzifiedDErr == XFUZZYVAR_NZ)
				defuzzified_ret_val = 0;

			// P4:
			if (fuzzifiedErr == XFUZZYVAR_NZ && fuzzifiedDErr == XFUZZYVAR_POS)
				defuzzified_ret_val = +1;

			// P5:
			if (fuzzifiedErr == XFUZZYVAR_NZ && fuzzifiedDErr == XFUZZYVAR_NEG)
				defuzzified_ret_val = -1;

			fcn.update(defuzzified_ret_val*fuzzyAmpValue);
			output = fcn.getOutput();

			max_Y_value = max(max_Y_value,output);

			time+=deltaT_sec;

			vx.push_back(time);
			vy.push_back(output);
		};

		vgdResults[2] = GraphData(vx,vy,-1,tr("Fuzzy Control"),Qt::red,false,3);
	}

	ui->plotResults->rescale(0,model_time_max,0,max_Y_value);

	ui->plotResults->updateGraph(vgdResults);
}

void MainWindow::onStartModellingChirp()
{

}
