#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <xqplot.h>

#include "xFuzzy.h"
#include "modelling.h"
#include "xPID.h"
#include "xTransferFcn.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    Ui::MainWindow *ui;

	vector<GraphData> vgdResults;
	vector<GraphData> vgdFuncErr;
	vector<GraphData> vgdFuncDiffErr;

	XFuzzyVariable fuzzyErr;
	XFuzzyVariable fuzzyDErr;

	void UpdateMemberFuncValues();

	bool InitMemberFuncGraph();
	void UpdateMemberFuncGraph();

	bool InitOutputGraph();
	//void UpdateOutputGraph();

private slots:
	void memberFuncChanged();

	void onStartModellingStep();
	void onStartModellingChirp();

	void onAbout();
	void onHelpContext();
	void onSave();
	void onLoad();

	// Sb Error
	void onSbErrNegLChanged(double newVal);
	void onSbErrNegRChanged(double newVal);

	void onSbErrZeroLChanged(double newVal);
	void onSbErrZeroRChanged(double newVal);

	void onSbErrPosLChanged(double newVal);
	void onSbErrPosRChanged(double newVal);

	// Sb DError
	void onSbDErrNegLChanged(double newVal);
	void onSbDErrNegRChanged(double newVal);

	void onSbDErrZeroLChanged(double newVal);
	void onSbDErrZeroRChanged(double newVal);

	void onSbDErrPosLChanged(double newVal);
	void onSbDErrPosRChanged(double newVal);



};

#endif // MAINWINDOW_H
