/*
 *	Modelling constants and auxiliary functions
 */

#ifndef H_MODELLING_H
#define H_MODELLING_H

#include "math.h"

const double deltaT_sec = 0.2;

// Auxiliary functions
double inline harmonic_target_function(float x)
{
	return 1+1.3*(exp(-x*0.02)/exp(x*0.02))*sin(exp(-x*0.01)*pow((double)x,1.3));
}

double inline nnFoldOutput(double PID_output,double K_amplification)
{
	return PID_output/K_amplification + 0.5;
};

double inline nnUnfoldOutput(double NN_output,double K_amplification)
{
	return (NN_output - 0.5)*K_amplification;
};

#endif
