#ifndef H_XFUZZY_H
#define H_XFUZZY_H

const int XFUNC_POSNEG = 0;
const int XFUNC_NEGPOSNEG = 1;
const int XFUNC_NEGPOS = 2;

struct XMemberFunc
{
	int type;
	float left,right;
	float co,c1;

	bool isValid()
	{
		if (type == XFUNC_POSNEG || type == XFUNC_NEGPOS)
		{
			if (left <= right) return true;
			return false;
		}

		if (type == XFUNC_NEGPOSNEG)
		{
			if (left <= 0 && right >=0)
				return true;
			return false;
		}


		return false;
	}

	void validate()
	{
		if (!isValid())
		{
			left = right-0.1;
		}
	}

	float getUbyX(float x)
	{
		switch(type)
		{
		case(XFUNC_POSNEG):
			if (x <= left)
				return 1;
			if (x >= right)
				return 0;
			return fabs(x-right)/fabs(right-left);
			break;

		case(XFUNC_NEGPOSNEG):
			if (x <= left || x >= right)
				return 0;
			if (x > left && x <= 0)
			{
				return fabs((left-x)/left);
			}

			if (x < right && x >= 0)
			{
				return fabs((right-x)/right);
			}

			break;

		case(XFUNC_NEGPOS):

			if (x <= left) return 0;
			if (x >= right) return 1;

			return fabs(x-left)/fabs(right-left);

			break;
		} // /switch

		return 0;
	}

	XMemberFunc()
	{
		type = 0;
	}

	XMemberFunc(int in_type, float in_left = 0, float in_right = 0)
	{
		type = in_type;
		left = in_left;
		right = in_right;
	}
};

const int XFUZZYVAR_NEG = 0;
const int XFUZZYVAR_NZ	= 1;
const int XFUZZYVAR_POS = 2;

struct XFuzzyVariable
{
	XMemberFunc neg,nz,pos;
	int retFuncIDByX(float x)
	{
		float neg_y = neg.getUbyX(x);
		float nz_y = nz.getUbyX(x);
		float pos_y = pos.getUbyX(x);

		if (neg_y >= nz_y)
		{
			if (neg_y >= pos_y) return XFUZZYVAR_NEG; // neg
			else return XFUZZYVAR_POS; // pos
		}
		if (nz_y >= neg_y)
		{
			if (nz_y >= pos_y) return XFUZZYVAR_NZ; // zero
			else return XFUZZYVAR_POS; // pos
		}

		if (pos_y >= nz_y)
		{
			if (pos_y >= neg_y) return XFUZZYVAR_POS; // pos
			else return XFUZZYVAR_NEG; // neg
		}

		return XFUZZYVAR_NZ; // no control otherwise (temporary !!!)
	}

};

#endif
