#ifndef H_XPID_H
#define H_XPID_H

class XPID
{
public:
	double derivative;
	XPID() {	zero_values();	};

	XPID(double P, double I,double D)
	{
		zero_values();
		init(P,I,D);
	};

	void init(double P, double I,double D)
	{
		cur_time = 0;

		Kp = P;		Ki = I;		Kd = D;

		integral = 0;
		f_initialized = true;
	};

	void update(double err,double p1err,double p2err,double dtS=0.2)
	{
		if (!f_initialized) return;
		
		integral += err*dtS;
		double deriv = (err - p1err)/dtS;
		if (dtS==0) deriv = 0;

		cur_time += dtS;

		output = Kp*err + Kd*deriv + Ki*integral;
	};

	double getCurTime() { return cur_time; };
	double getOutput() { return output; };
	
	enum TUNE_RULE
	{
		TUNE_CLASSIC = 0,
		TUNE_PESSEN,
		TUNE_OVERSHOOT,
		TUNE_NOOVERSHOOT,
		TUNE_P,
		TUNE_PI,
		TUNE_ZEIGERNICHOLS
	};	

	int AutoTune(double Ku, double Tu, TUNE_RULE rule = TUNE_PESSEN)
	{
		switch(rule)
		{
		case(TUNE_CLASSIC):
			Kp = Ku / 1.7;
			Ki = 2.0 * Kp / Tu;
			Kd = Kp*Tu / 8.0;			
			break;
		case(TUNE_PESSEN):
			Kp = 0.7*Ku;
			Ki = 2.5*Kp / Tu;
			Kd = 0.15*Kp / Tu;
			break;
		case(TUNE_OVERSHOOT):
			Kp = 0.33*Ku;
			Ki = 2.0*Kp / Tu;
			Kd = Kp*Tu / 3.0;
			break;
		case(TUNE_NOOVERSHOOT):
			Kp = 0.2*Ku;
			Ki = 2.0*Kp/ Tu;
			Kd = Kp*Tu / 3.0;
			break;
		case(TUNE_P):
			Kp = Ku / 2.0;
			Ki = 0.0;
			Kd = 0.0;
			break;
		case(TUNE_PI):
			Kp = Ku / 2.2;
			Ki = 1.2*Kp / Tu;
			Kd = 0.0;
			break;
		case(TUNE_ZEIGERNICHOLS):
			Kp = 0.6*Ku;
			Ki = 2.0*Kp/Tu;
			Kd = Kp*Tu/8.0;
			break;
		default: return -1;
		}; // switch tune_rule

		return 0;
	} // AutoTune func


private:
	void zero_values()
	{
		f_initialized = false;
		Kp = Ki = Kd = cur_time = 0;
		integral = 0;
	};

	bool f_initialized;
	double Kp,Ki,Kd;
	double cur_time; // seconds

	double integral;

	double output;
};

#endif
