#ifndef H_XQSCALED_LABEL_H
#define H_XQSCALED_LABEL_H

// Class provides overload functionality to draw scaled label

#include <QLabel>
#include "windows.h"
#include <QResizeEvent>

class XQScaledLabel : public QLabel
{
	Q_OBJECT
public:
	XQScaledLabel(QWidget * parent = 0) : QLabel(parent)
	{
		this->setScaledContents(true);
	}
public:
	virtual void resizeEvent(QResizeEvent *event)
	{
		QSize sizePx = this->pixmap()->size();
		float targetAspect = (float)sizePx.width() / (float)sizePx.height();
		float w = this->size().width();
		resize(w,w/targetAspect);
		return;
	}
};

#endif
