#ifndef H_XTRANSFER_FCN_H
#define H_XTRANSFER_FCN_H

using namespace std;

class XTRANSFERFCN
{
private:

	double vz[3]; // Stack of input values VZ. and stack of ouput values VY
	double vy[3]; // read description below, why size is 2, not 3. Optimization.
	size_t update_count;

public:	
	XTRANSFERFCN(): update_count(0)
	{
		memset(vz,0,sizeof(vz));
		memset(vy,0,sizeof(vy));
	};

	double update(double input_value)
	{
		// stack of input values. shift before computing
		vz[2] = vz[1]; // VZ [2] <- [1] <- [0 is target]
		vz[1] = vz[0]; // input value is a target value (open loop)
		vz[0] = input_value; // or input value is an Error (E=target-last_ouput)

		double y = 0.1666*vz[0] + 0.15092*vz[1] - 
			vy[0]*(-1.5999) - vy[1]*(0.6323);
		
		/* stack of output values. note: original function looks like
		double y = 0.1666*vz[1] + 0.15092*vz[2] - 
			vy[1]*(-1.5999) - vy[2]*(0.6323);
		but since we do shift after computing, we can remove one stack shift
		and make VY size = 2.
		*/
		vy[2] = vy[1];
		vy[1] = vy[0];
		vy[0] = y;
		
		update_count++;
		return y;
	};

	double getOutput() { return vy[0]; };

	size_t getUpdCount() { return update_count; };
};

#endif
