#ifdef _MSC_VER
#include "stdafx.h"
#endif

#include "xqplot.h"

class XCurve: public QwtPlotCurve
{
public:
	XCurve(const QString &title): QwtPlotCurve(title)
    {
        setRenderHint(QwtPlotItem::RenderAntialiased);
    }

    void setColor(const QColor &color,bool f_solid = 0, float width = 2.0)
    {
        QColor c = color;
        c.setAlpha(150);
		
		if (f_solid)
		{
			setPen(c);
			setBrush(c);
		}
		else
		{
			setPen(QPen(c,width));
		}
    }
};


XPlot::XPlot(QWidget * parent): QwtPlot(parent)
{
	setAutoReplot(false); // we need to call replot to make changes
}


XPlot::XPlot(QWidget *parent,
			 float maxX, float maxY, vector<GraphData> &vData,
			 bool f_show_legend,
			 QString HAxisName,
			 QString VAxisName) :
	QwtPlot(parent)
{
	init(maxX, maxY, vData, f_show_legend, HAxisName, VAxisName);
}

XPlot::~XPlot()
{

}

bool XPlot::init(float maxX, float maxY, const vector<GraphData> &vData,
		  bool f_show_legend,
		  QString HAxisName,
		  QString VAxisName)
{
	if (!init(0,maxX,0,maxY,f_show_legend,HAxisName,VAxisName))
		return false;

	drawGraph(vData);

	return true;
}

bool XPlot::init(float minX, float maxX, float minY, float maxY,
		  bool f_show_legend,
		  QString HAxisName,
		  QString VAxisName)
{
	m_minX = minX;
	m_maxX = maxX;

	m_minY = minY;
	m_maxY = maxY;

	m_fShowLegend = f_show_legend;

	setAutoReplot(false); // we need to call replot to make changes

	plotLayout()->setAlignCanvasToScales(true);

	if (f_show_legend)
	{
		m_legend.setItemMode(QwtLegend::CheckableItem);
		insertLegend(&m_legend, QwtPlot::RightLegend);
	};

	setAxisTitle(QwtPlot::xBottom, HAxisName);
	setAxisScale(QwtPlot::xBottom, minX, maxX);
	setAxisLabelRotation(QwtPlot::xBottom, 0.0);
	setAxisLabelAlignment(QwtPlot::xBottom, Qt::AlignRight | Qt::AlignBottom);


	setAxisTitle(QwtPlot::yLeft, VAxisName);
	setAxisScale(QwtPlot::yLeft, minY, maxY);
	//setAxisLabelRotation(QwtPlot::yLeft, 10.0);
	setAxisLabelAlignment(QwtPlot::yLeft, Qt::AlignTop | Qt::AlignLeft);


	return true;
}

void XPlot::showCurve(QwtPlotItem *item, bool on)
{
    item->setVisible(on);
    
	if (legend())
	{
		QWidget *w = legend()->find(item);
		if ( w && w->inherits("QwtLegendItem") ) 
			((QwtLegendItem *)w)->setChecked(on);
	};
    
    replot();
}

bool XPlot::drawGraph(vector<GraphData> vGraphData)
{
	vData = vGraphData;

	vCurves.resize(vData.size());

	for (size_t i= 0; i < vData.size(); i++)
	{
		XCurve *curve;

		curve = new XCurve(vData[i].name);
		curve->setColor(vData[i].color,vData[i].f_solid,vData[i].width);
		curve->setZ(-i);//curve->z() - 1);
		curve->attach(this);
		vCurves[i].curve = curve;

		if (vData[i].vx.size() == 0)
		{
			vData[i].vx.push_back(0.0);
			vData[i].vy.push_back(0.0);
			vData[i].count = vData[i].vx.size();
		};

		/*
		int last_item = vData[i].count - 1;
		if (vData[i].vx[last_item] != m_maxX)
		{
			vData[i].vx.push_back(m_maxX);
			vData[i].vy.push_back(vData[i].vy[last_item]);
			vData[i].count = vData[i].vx.size();
		}
		*/

		vCurves[i].curve->setRawSamples(&(vData[i].vx[0]),
			&(vData[i].vy[0]),
			vData[i].count);
	};

	for (size_t i = 0; i < vCurves.size(); i++)
	{
		showCurve(vCurves[i].curve, true);
	};

	if (m_fShowLegend)
	{
		connect(this, SIGNAL(legendChecked(QwtPlotItem *, bool)),
			SLOT(showCurve(QwtPlotItem *, bool)));
	};

	replot();

	return true;
}

bool XPlot::updateGraph(vector<GraphData> vGraphData)
{
	vData = vGraphData;

	//vCurves.resize(vData.size());

	for (size_t i= 0; i < vData.size(); i++) // !!! range!!!
	{
		XCurve *curve = (XCurve*)vCurves[i].curve; // !!!

		curve->detach();
		curve->setColor(vData[i].color,vData[i].f_solid,vData[i].width);
		curve->setZ(-i);//curve->z() - 1);
		curve->attach(this);


		if (vData[i].vx.size() == 0)
		{
			vData[i].vx.push_back(0.0);
			vData[i].vy.push_back(0.0);
			vData[i].count = vData[i].vx.size();
		};

		vCurves[i].curve->setRawSamples(&(vData[i].vx[0]),
			&(vData[i].vy[0]),
			vData[i].count);

	};

	for (size_t i = 0; i < vCurves.size(); i++)
	{
		showCurve(vCurves[i].curve, true);
	};

	replot();

	return true;
}

void XPlot::rescale(float minX, float maxX, float minY, float maxY)
{
	setAxisScale(QwtPlot::xBottom, minX, maxX);
	setAxisScale(QwtPlot::yLeft, minY, maxY);
}



