#ifndef H_XWPLOT_H
#define H_XWPLOT_H

#include <qwt_plot.h>
#include <qwt_plot_layout.h>
#include <qwt_plot_curve.h>
#include <qwt_scale_draw.h>
#include <qwt_scale_widget.h>
#include <qwt_legend.h>
#include <qwt_legend_item.h>

class QwtPlotCurve; // external class qwt_plot_curve

#include <vector>

using namespace std;

struct GraphData
{
	vector<double> vx;
	vector<double> vy;
	int count;
	QColor color;
	bool f_solid;
	QString name;
	float width;

	GraphData()
	{
		count=0;
		f_solid = false;
		width = 2;
	}

	GraphData(vector<double> in_vx,
		vector<double> in_vy,
		int count_ = -1,
		QString nm_ = QString("no name"),
		QColor color_ = Qt::red,
		bool f_solid_ = true,
		float width_ = 2)
	{
		vx = in_vx;
		vy = in_vy;
			
		if (vx.size() != vy.size())
		{
			count = 0;
			return;
		}
		
		if (count_ < 0) count = vx.size();
		else count = count_;

		color = color_;
		f_solid = f_solid_;
		name = nm_;
		width = width_;
	}
};

class XPlot : public QwtPlot
{
    Q_OBJECT
public:
	XPlot(QWidget * parent = 0);
	XPlot(QWidget * parent,
		  float maxX, float maxY, vector<GraphData> &vData,
		  bool f_show_legend = false,
		  QString HAxisName = QString("x"),
		  QString VAxisName = QString("y"));
	virtual ~XPlot();

	bool init(float maxX, float maxY, const vector<GraphData> &vData,
			  bool f_show_legend = false,
			  QString HAxisName = QString("x"),
			  QString VAxisName = QString("y"));

	bool init(float minX, float maxX, float minY, float maxY,
			  bool f_show_legend = false,
			  QString HAxisName = QString("x"),
			  QString VAxisName = QString("y"));

    const QwtPlotCurve *cpuCurve(int id) const { return vCurves[id].curve; }

	bool drawGraph(vector<GraphData> vData);

	bool updateGraph(vector<GraphData> vData);

	void empty() {  };

	void rescale(float minX, float maxX, float minY, float maxY);



private Q_SLOTS:
    void showCurve(QwtPlotItem *, bool on);

private:
	float m_maxX,m_minX;
	float m_maxY,m_minY;

	struct CURVES
    {
        QwtPlotCurve *curve;
    };

	bool m_fShowLegend;
	QwtLegend m_legend;

	vector<CURVES> vCurves;
	vector<GraphData> vData;
};


#endif
